/*
 * Decompiled with CFR 0.152.
 */
package cds.mocmulti;

public class Buf {
    public byte[] buf;
    protected int offset;

    public Buf(int size) {
        this.buf = new byte[size];
        this.offset = 0;
    }

    public void reset() {
        this.offset = 0;
    }

    public static int sizeOfString(String s) {
        return 2 + (s == null ? 0 : s.getBytes().length);
    }

    public void memoString(String s) {
        if (s == null) {
            this.memoShort((short)-1);
            return;
        }
        byte[] a = s.getBytes();
        this.memoShort((short)a.length);
        System.arraycopy(a, 0, this.buf, this.offset, a.length);
        this.offset += a.length;
    }

    public void memoBoolean(boolean v) {
        this.buf[this.offset++] = (byte)(v ? 1 : 0);
    }

    public void memoByte(byte v) {
        this.buf[this.offset++] = v;
    }

    public void memoShort(short v) {
        this.buf[this.offset++] = (byte)(v & 0xFF);
        this.buf[this.offset++] = (byte)(v >> 8 & 0xFF);
    }

    public void memoInteger(int v) {
        this.buf[this.offset++] = (byte)(v & 0xFF);
        this.buf[this.offset++] = (byte)(v >> 8 & 0xFF);
        this.buf[this.offset++] = (byte)(v >> 16 & 0xFF);
        this.buf[this.offset++] = (byte)(v >> 24 & 0xFF);
    }

    public void memoLong(long v) {
        this.buf[this.offset++] = (byte)(v & 0xFFL);
        this.buf[this.offset++] = (byte)(v >> 8 & 0xFFL);
        this.buf[this.offset++] = (byte)(v >> 16 & 0xFFL);
        this.buf[this.offset++] = (byte)(v >> 24 & 0xFFL);
        this.buf[this.offset++] = (byte)(v >> 32 & 0xFFL);
        this.buf[this.offset++] = (byte)(v >> 40 & 0xFFL);
        this.buf[this.offset++] = (byte)(v >> 48 & 0xFFL);
        this.buf[this.offset++] = (byte)(v >> 56 & 0xFFL);
    }

    public void skip(int i) {
        this.offset += i;
    }

    public String readString() {
        short n = this.readShort();
        if (n == -1) {
            return null;
        }
        String s = new String(this.buf, this.offset, (int)n);
        this.offset += n;
        return s;
    }

    public boolean readBoolean() {
        return this.buf[this.offset++] != 0;
    }

    public byte readByte() {
        return this.buf[this.offset++];
    }

    public short readShort() {
        return (short)(this.buf[this.offset++] & 0xFF | (this.buf[this.offset++] & 0xFF) << 8);
    }

    public int readInteger() {
        return this.buf[this.offset++] & 0xFF | (this.buf[this.offset++] & 0xFF) << 8 | (this.buf[this.offset++] & 0xFF) << 16 | (this.buf[this.offset++] & 0xFF) << 24;
    }

    public long readLong() {
        return (long)this.buf[this.offset++] & 0xFFL | ((long)this.buf[this.offset++] & 0xFFL) << 8 | ((long)this.buf[this.offset++] & 0xFFL) << 16 | ((long)this.buf[this.offset++] & 0xFFL) << 24 | ((long)this.buf[this.offset++] & 0xFFL) << 32 | ((long)this.buf[this.offset++] & 0xFFL) << 40 | ((long)this.buf[this.offset++] & 0xFFL) << 48 | ((long)this.buf[this.offset++] & 0xFFL) << 56;
    }
}

